# Contract Killer
### The popular open-source contract for web professionals by [Stuff & Nonsense](https://stuffandnonsense.co.uk/)

* Originally published: 23rd December 2008
* Revised date: March 15th 2016 
* Revised by Bytes Unlimited : Feb 3rd 2020

* * *


**Between** [company name]

**And** [customer name].

### Summary:

We’ll always do our best to fulfill your needs and meet your expectations, but it’s important to have things written down so that we both know what’s what, who should do what and when, and what will happen if something goes wrong. In this contract you won’t find any complicated legal terms or long passages of unreadable text. We’ve no desire to trick you into signing something that you might later regret. What we do want is what’s best for both parties, now and in the future.

### So in short;

You **customer name,** located at **customer address** (“You”) are hiring us **company name** (“We or Us”) to:

- **Design and develop a web site**

For the estimated total price of **total** as outlined in our previous correspondence.

### What do both parties agree to?

**You**: You have the authority to enter into this contract on behalf of yourself, your company or your organization. You’ll give us the assets and information we tell you we need to complete the project. You’ll do this when we ask and provide it in the formats we ask for. You’ll review our work, provide feedback and approval in a timely manner too. Deadlines work two ways, so you’ll also be bound by dates we set together. You also agree to stick to the payment schedule set out at the end of this contract.

**Us**: We have the experience and ability to do everything we’ve agreed with you and we’ll do it all in a professional and timely manner. We’ll endeavor to meet every deadline that’s set and on top of that we'll maintain the confidentiality of everything you give us.

## Site Design Details

### Design

We create look-and-feel designs, and flexible layouts that adapt to the capabilities of many devices and screen sizes. We create designs iteratively and use predominantly HTML and CSS so we won’t waste time mocking up every template as a static visual. We may use visuals to indicate a creative direction (color, texture and typography.) We call that ‘atmosphere.’

You’ll have plenty of opportunities to review our work and provide feedback. We’ll either share a Dropbox, Google Drive folder or Github repository or development site with you and we’ll have regular, possibly daily contact.

If, at any stage, you change your mind about what you want to be delivered and are not happy with the direction our work is taking you’ll pay us in full for the time we’ve spent working with you until that point and terminate this contract.

### Text content

Unless agreed separately, we’re not responsible for inputting text or images into your content management system or creating every page on your website. We provide professional copywriting and editing services, so if you’d like us to create new content or input content for you, we can provide a separate estimate for that.

### Graphics and photographs

You should supply graphic files in an editable, vector digital format. You should supply photographs in a high resolution digital format. If you choose to buy stock photographs, we can suggest stock libraries. If you’d like us to search for photographs for you, we can provide a separate estimate for that.

### HTML, CSS and JavaScript

We deliver web page types developed from HTML markup, CSS stylesheets for styling and unobtrusive JavaScript for feature detection, poly-fills and behaviors.

### Browser testing

Browser testing no longer means attempting to make a website look the same in browsers of different capabilities or on devices with different size screens. It does mean ensuring that a person’s experience of a design should be appropriate to the capabilities of a browser or device.

We test our work in current versions of major desktop browsers including those made by Apple (Safari), Google (Chrome), Microsoft (Edge), Mozilla Firefox. We won’t test in other older browsers, including Microsoft Internet Explorer 11 for Windows, unless we agreed separately. If you need an enhanced design for an older browser, we can provide a separate estimate for that.

### Mobile browser testing

Mobile browser Testing using popular smaller screen devices is essential in ensuring that a person’s experience of a design is appropriate to the capabilities of the device they’re using. We test our designs in:

iOS 10 for iPhone 7 Devices only: Safari, Google Chrome 

We won’t test in Blackberry, Opera Mini/Mobile, Android devices, Windows or other mobile browsers unless we agreed separately. If you need us to test using these, we can provide a separate estimate for that.

### Technical Support and Web Hosting

We’re not a website hosting provider, but we do offer hosting on our rented servers. Thus we do offer limited support for website hosting, email or other services relating to hosting. You may already have professional hosting and you might even manage that hosting in-house. If you don’t, we can set up an account for you at one of our preferred hosting providers. We can set up your site on a server, plus any statistics software such as Google Analytics and we can provide a separate estimate for that. Then, the updates to, and management of that server will be up to you. If you need Website Hosting or CMS Management support, we can provide a separate estimate for that.

### Maintenance and Security
We do not automatically include support for any type of maintenance, backups or security configurations/updates after the final design is completed. We are not liable for any hacking or intrusion to the site or CMS used. If you need maintenance or security support, we can provide a separate estimate for that.

### Search engine optimization (SEO)

We don’t guarantee improvements to your website’s search engine ranking, but the web pages that we develop are accessible to search engines. If you need comprehensive and monthly SEO support, we can provide a separate estimate for that.

### Changes and revisions

We don’t want to limit your ability to change your mind. The price at the beginning of this contract is based on the number of weeks that we estimate we’ll need to accomplish everything you’ve told us you want to achieve, but we’re happy to be flexible. If you want to change your mind or add anything new, that won’t be a problem as we’ll provide a separate estimate for those additional weeks.

### Legal stuff

We’ll carry out our work in accordance with good industry practice and at the standard expected from a suitably qualified person with relevant experience.

That said, we can’t guarantee that our work will be error-free and so we can’t be liable to you or any third-party for damages, including lost profits, lost savings or other incidental, consequential or special damages, even if you’ve advised us of them.

Your liability to us will also be limited to the amount of fees payable under this contract and you won’t be liable to us or any third-party for damages, including lost profits, lost savings or other incidental, consequential or special damages, even if we’ve advised you of them.

Finally, if any provision of this contract shall be unlawful, void, or for any reason unenforceable, then that provision shall be deemed severable from this contract and shall not affect the validity and enforceability of any remaining provisions.

### Intellectual property rights

Just to be clear, “Intellectual property rights” means all patents, rights to inventions, copyright (including rights in software) and related rights, trademarks, service marks, get up and trade names, internet domain names, rights to goodwill or to sue for passing off, rights in designs, database rights, rights in confidential information (including know-how) and any other intellectual property rights, in each case whether registered or unregistered and including all applications (or rights to apply) for, and renewals or extensions of, such rights and all similar or equivalent rights or forms of protection which subsist or shall subsist now or in the future in any part of the world.

First, you guarantee that all elements of text, images or other artwork you provide are either owned by your good selves, or that you’ve permission to use them. When you provide text, images or other artwork to us, you agree to protect us from any claim by a third party that we’re using their intellectual property.

We guarantee that all elements of the work we deliver to you are either owned by us or we’ve obtained permission to provide them to you. When we provide text, images or other artwork to you, we agree to protect you from any claim by a third party that you’re using their intellectual property. Provided you’ve paid for the work and that this contract hasn’t been terminated, we’ll assign all intellectual property rights to you as follows:

You’ll own the website we design for you plus the visual elements that we create for it. We’ll give you source files and finished files and you should keep them somewhere safe as we’re not required to keep a copy. You own all intellectual property rights of text, images, site specification and data you provided, unless someone else owns them.

We’ll own any intellectual property rights we’ve developed prior to, or developed separately from this project and not paid for by you. We’ll own the unique combination of these elements that constitutes a complete design and we’ll license its use to you, exclusively and in perpetuity for this project only, unless we agree otherwise.

### Exclusivity
Unless approved by both parties, [Our Company] will not provide competing services for any of your competitors and your use of any other third party providing the same services in this contract will be considered a violation of these terms in which the face value of the contract will be owed in full.

Any contractors involved in this contract will either be direct employees or partners of [Our Company], contractors sourced by [Our Company], or full time employees and partners of yours. Any part-time employee of yours will be bound by the same NDA and Non-compete contracts that [Our Company] uses for internal employees and contractors.

### Displaying our work

We love to show off our work, so we reserve the right to display all aspects of our creative work, including sketches, work-in-progress designs and the completed project on our portfolio and in articles on websites, in magazine articles and in books.

### Payment schedule

We’re sure you understand how important it is that you pay the invoices that we send you promptly. As we’re also sure you’ll want to stay friends, you agree to stick tight to the following payment schedule.

**Payment details**

**Payment schedule**

We issue invoices electronically. Our payment terms are [number] days from the date of invoice. All proposals are quoted in USD and payments will be made at the equivalent conversion rate at the date the transfer is made.

You agree to pay all charges associated with international transfers of funds, if applicable. The appropriate bank account or approved payment method details will be printed on our electronic invoice. We reserve the right to charge interest on all overdue debts at the rate of 5% per month or part of a month.

### Final Details

Neither of us can transfer this contract to anyone else without the other’s permission.

We both agree that we’ll adhere to all relevant laws and regulations in relation to our activities under this contract and not cause the other to breach any relevant laws or regulations.

This contract stays in place and need not be renewed. If for some reason one part of this contract becomes invalid or unenforceable, the remaining parts of it remain in place.

Although the language is simple, the intentions are serious and this contract is a legal document under exclusive jurisdiction of **United States** courts.

### The dotted line 

Signed by and on behalf of **company name**
Signed by and on behalf of **customer name
Date **date**

Everyone should sign above and keep a copy for their records.